// VMF settings class
CVMFSettings	= OOP_Derive( CDatabase );

// constructor.
function CVMFSettings:__ctor( )
	// setup the vmf info table.
	if( !self:TableExists( "vmfsuite_vmfinfo" ) ) then
		self:Query(
			"CREATE TABLE IF NOT EXISTS vmfsuite_vmfinfo ( filename VARCHAR(255), flag VARCHAR(32), spawnlimit INTEGER );"
		);
	
	end
	
	// setup the client vmfs table.
	if( !self:TableExists( "vmfsuite_clientvmfs" ) ) then
		self:Query(
			"CREATE TABLE IF NOT EXISTS vmfsuite_clientvmfs ( filename VARCHAR(255), steamid VARCHAR(32) );"
		);
	
	end
	
end

// get vmf flag.
function CVMFSettings:GetFlag( filename )
	// fetch flag if it exists.
	local res = self:Query( "SELECT state FROM vmfsuite_vmfinfo WHERE filename = '" .. filename .. "' LIMIT 1" );
	if( !res ) then return VMF_FLAG_NONE; end

	// flag exists return flag.
	return res[1][ 'flag' ];

end

// set vmf flag
function CVMFSettings:SetFlag( filename, flag )
	// already eists?
	if( self:Query( "SELECT filename FROM vmfsuite_vmfinfo WHERE filename = '" .. filename .. "' LIMIT 1" ) ) then
		// update
		self:Query(
			"UPDATE vmfsuite_vmfinfo SET flag = " .. flag .. " WHERE filename = '" .. filename .. "'"
		);
		
	else
		// add
		self:Query(
			"INSERT INTO vmfsuite_vmfinfo ( filename, flag, spawnlimit ) VALUES ( '" .. filename .. "', " .. flag .. ", -1 )"
		);
	
	end

end


// vmf limits
function CVMFSettings:SetLimit( filename, limit )
	// already eists?
	if( self:Query( "SELECT filename FROM vmfsuite_vmfinfo WHERE filename = '" .. filename .. "' LIMIT 1" ) ) then
		// update
		self:Query(
			"UPDATE vmfsuite_vmfinfo SET spawnlimit = " .. limit .. " WHERE filename = '" .. filename .. "' LIMIT 1"
		);
		
	else
		// add
		self:Query(
			"INSERT INTO vmfsuite_vmfinfo ( filename, state, spawnlimit ) VALUES ( '" .. filename .. "', " .. VMF_FLAG_NONE .. ", " .. limit .. " )"
		);
		
	end

end

function CVMFSettings:GetLimit( filename )
	// fetch flag if it exists.
	local res = self:Query( "SELECT state FROM vmfsuite_vmfinfo WHERE filename = '" .. filename .. "' LIMIT 1" );
	if( !res ) then return -1; end
	
	// flag exists return flag.
	return res[1][ 'spawnlimit' ];

end
